#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Squircles go to the discoMod01.fsh   by   gouky   
//https://www.shadertoy.com/view/Xl2GDm
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//
// #TeamSquircle
//
#define PI				3.1415926535
#define STEP_COUNT		16
#define EPS				0.01

#define ROTATE_LIGHT			1
#define DANCING_SQUIRCLES		1

// Smoke noise based on https://www.shadertoy.com/view/Mlj3W1
#define ENABLE_SMOKE	1	// Change me!Change me!Change me!Change me!

struct	Squircle
{
    vec3	color;
    float	d;
    vec2	uv;
};

#define SMOKE_MAX_STEPS  8
#define SMOKE_MIN_STEP  0.010
    
// noise from iq's hell shader
float noise( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);
	f = f*f*(3.0-2.0*f);
	
	vec2 uv = (p.xy+vec2(37.0,17.0)*p.z) + f.xy;
	vec2 rg = texture2D( texture0, (uv+ 0.5)/256.0, -100.0 ).yx;
	return mix( rg.x, rg.y, f.z ) - 0.5;
}

///////////////////////////////
float NoiseSample(vec3 orp)
{
    float t = iTime * 0.01;
    float m = 0.0;
    
    vec3 uv = orp + vec3(t, 0.0, 0.0);
    float n = noise(uv * 10.0) - 0.5;

    uv = orp + vec3(t * 0.2, 0.0, 0.0);
    n += noise(uv * 22.50) * 0.5;

    uv = orp + vec3(t * 1.0, 0.0, 0.0);
    n += noise(uv * 52.50) * 0.5;

    uv = orp + vec3(t * 1.8, 0.0, 0.0);
    n += noise(uv * 152.50) * 0.25;

    return n;
}

float Smoke(in vec3 ro, in vec3 rd)
{
    vec3 rp = ro;
    float smoke = 0.0;
    
    for (int i = 0; i < SMOKE_MAX_STEPS; ++i)
    {
        rp += rd * max(SMOKE_MIN_STEP, 0.0);
        float h = NoiseSample(vec3(rp.xy, float(i)*1.5));
        
        smoke += abs(h);
    }
    
    smoke /= float(SMOKE_MAX_STEPS+1);
    
    return smoke;
}

// shamelessly stolen from iq!
float hash(float n)
{
    return fract(sin(n)*43758.5453123);
}

Squircle	check(Squircle x, Squircle y)
{
    if(x.d <= y.d)
        return x;
    
    return y;
    //return x.d <= y.d ? x : y;
}

Squircle f(vec2 p, vec2 centre, float mult, float radius, float bias, float fft)
{
    Squircle ret;
    
    ret.color = vec3(1.0, 0.0, 1.0);
    
    float cosTheta = cos(iTime);
    float sinTheta = sin(iTime);
    
    vec2 ab = p-centre;
    
    vec2 rotatedPos = vec2(ab.x * cosTheta - ab.y * sinTheta, ab.x * sinTheta + ab.y * cosTheta);
    ab = rotatedPos;
    
#if DANCING_SQUIRCLES == 0
    float power = 0.5 + 2.0*(1.0+sin(iTime+bias));
#else
    float power = 0.5 + 0.90*(sin((fft * (30.0+bias))+2.0)*0.5+0.5);
#endif
    
    float dist = pow(abs(ab.x),power) + pow(abs(ab.y),power);
   
    ret.d = dist < pow(radius,power) ? EPS : 1.0;
    ret.uv = vec2(
            (abs(ab.x+radius) / radius*0.5),
            (abs(ab.y+radius) / radius*0.5));
   	    
    return ret;
}

Squircle SampleScene(in vec2 uv, in float fft)
{
    Squircle r;
    
    r.d = 100.0;
    
    vec2 pos;
    
    pos.x = cos(iTime)*0.5;
    pos.y = sin(iTime)*0.5;
    
    r = check(r, f(uv, pos, 1.0, 0.15, 0.0, fft));

    pos.x = cos(iTime+PI/2.0)*0.5;
    pos.y = sin(iTime+PI/2.0)*0.5;
    
    r = check(r, f(uv, pos, 1.0, 0.15, 0.5, fft));
   
    pos.x = cos(iTime+PI)*0.5;
    pos.y = sin(iTime+PI)*0.5;
    
    r = check(r, f(uv, pos, 1.0, 0.15, 1.0, fft));
      
    pos.x = cos(iTime-PI/2.0)*0.5;
    pos.y = sin(iTime-PI/2.0)*0.5;
    
    r = check(r, f(uv, pos, 1.0, 0.15, 1.5, fft));
   
    return r;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 q = fragCoord.xy / iResolution.xy;
    vec2 uv = -1.0 + 2.0 * q;
    uv.x *= iResolution.x/iResolution.y;
    
	vec3 color = vec3(0.0);
    vec2 pos = vec2(0.0,0.0);
    
    float cosTheta = cos(iTime);
    float sinTheta = sin(iTime);
           
	float smoke = 1.0;

#if ENABLE_SMOKE == 1
    smoke = Smoke(vec3(0.0, 0.0, -1.1), vec3(uv, 1.0)) * 1.5;
#endif
    
    //	
    float freqs = 0.0;

    float weights[5];
    weights[0] = 0.4;
    weights[1] = 0.1;
    weights[2] = 0.2;
    weights[3] = 0.2;
    weights[4] = 0.2;

    //	dirty approx.
    freqs += texture2D(texture0, vec2( 0.01, 0.25 ) ).x * weights[0];		// 0.01
    freqs += texture2D( texture0, vec2( 0.25, 0.25 ) ).x * weights[1];		// 0.07
    freqs += texture2D( texture0, vec2( 0.50, 0.25 ) ).x * weights[2];		// 0.15
    freqs += texture2D( texture0, vec2( 0.75, 0.25 ) ).x * weights[3];		// 0.30
    freqs += texture2D( texture0, vec2( 0.99, 0.25 ) ).x * weights[4];		// 0.30

    float fft = freqs;///5.0;
    fft += 0.5;

    //	Scene
    Squircle scene = SampleScene(uv, fft);    
    
    //	lights
    {
        vec4 lightColor[5];
    	vec2 lightPos[5];
        
        lightPos[0] 	= vec2(0.0, 0.0);
        lightPos[1] 	= vec2(1.0, 0.0);
        lightPos[2] 	= vec2(-1.0, 0.0);
        lightPos[3] 	= vec2(0.0, 1.0);
        lightPos[4] 	= vec2(0.0,-1.0);
        lightColor[0] 	= vec4(1.0, 0.2, 0.4, 0.1); 	//	2.0
        lightColor[1] 	= vec4(1.0, 1.0, 0.5, 0.5);		//	0.0
        lightColor[2] 	= vec4(0.2, 1.0, 1.0, 0.5);		//	0.5
        lightColor[3] 	= vec4(1.0, 0.2, 1.0, 1.2);		//	1.5
        lightColor[4] 	= vec4(0.2, 1.0, 0.2, 1.2);		//	1.0

#if ROTATE_LIGHT == 1        
        lightPos[1].y = cos(iTime);
        lightPos[1].x = sin(iTime);
        lightPos[2].y = -cos(iTime);
        lightPos[2].x = -sin(iTime);
		lightPos[3].y = -cos(PI*0.5+iTime);
        lightPos[3].x = -sin(PI*0.5+iTime);
		lightPos[4].y = cos(PI*0.5+iTime);
        lightPos[4].x = sin(PI*0.5+iTime);        
#endif
        
        color = vec3(0.0);
        for(int i = 0; i < 5; ++i)
        {
            vec2 rayOrigin = vec2(uv);
            vec2 ray = lightPos[i] - rayOrigin;
            float rayLength = length(ray);
            vec2 rayDir = ray / rayLength;

            float raySteps = rayLength / float(STEP_COUNT);

            float acc = 0.0;
            float t = 0.0;
            float offset = hash(fragCoord.y*iResolution.x + fragCoord.x + iTime);

            for(int stepIndex = 0; stepIndex < STEP_COUNT; stepIndex++)
            {
                vec2 P = rayOrigin + rayDir * (t + offset * 0.1);
                float d = SampleScene(P, fft).d;

                if(d <= EPS) 
                {
                    acc += 1.0;
                }

                t += raySteps;
            }

            acc = acc/float(STEP_COUNT);
            acc = clamp(1.0-acc, 0.0, 1.0);

#if ENABLE_SMOKE == 1
            smoke = scene.d <= EPS ? 1.0 : smoke * acc;
#endif            
            
            const float maxAtten = 0.22;		//0.2
            
            float attenDist = max(clamp(maxAtten*(sin((fft * 20.0)+lightColor[i].w)*0.5+0.5), 0.0, maxAtten), 0.01);
            attenDist = i == 0 ? max(attenDist, 0.1) : attenDist;
            float atten = (rayLength/attenDist);
            
            acc = acc / atten;

            color += vec3(acc) * lightColor[i].xyz * smoke;// * color;
        }
    }
    
    // Squircles are the best!   
    if(scene.d <= EPS)
    {
        vec2 squircleUv = scene.uv * 2.0 - 1.0;
        float gradient = (1.0 - length(squircleUv) * 0.5);
       
        vec3 basecolor = mix(vec3(1.0, 0.2, 0.4), vec3(1.0, 1.0, 0.0), cos(iTime));
        basecolor = color;//vec3(1.0);
        color = vec3(gradient) * basecolor * 2.0;
    }
    
    fragColor = vec4(color,1.0); 
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

